<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_infos', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger("status")->nullable();
            $table->string('title')->nullable();
            $table->longText('body')->nullable();
            $table->smallInteger('works')->nullable();
            $table->smallInteger('doneWorks')->nullable();
            $table->date('d1')->nullable();
            $table->date('d2')->nullable();
            $table->date('d3')->nullable();
            $table->string('admin')->nullable();
            $table->bigInteger('admin_id')->unsigned()->nullable();
            $table->string('project')->nullable();
            $table->bigInteger('project_id')->unsigned()->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
//        Schema::dropIfExists('project_infos');
    }
};
