<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Models\task;
use App\Models\notes;
use App\Models\project;
use App\Models\Admin;
use App\Classes\CalendarUtils;

class taskcontroller extends Controller
{
    public function index()
    {
        //نمایش تسک یا نوت بر اثاس مجوز و ادمین
        if ($Admin = Admin::where('name', $_COOKIE['admin'])->first()){
                $tasks = task::all();
        }
        return view('content.tasks.index',compact('tasks','Admin'));
    }

    public function editTaskStatus(Request $request, $id)
    {
        $task = task::where('id', $id)->first();
        $task->status  = $request->status;
        $task->save();
        if ($Admin = Admin::where('name', $_COOKIE['admin'])->first()){
            if ($Admin->premises == 0){
                $tasks = task::all();
            }else{
                $tasks = task::where('admin_id', $Admin->id)->get();
            }
        }
        return view('content.tasks.index',compact('tasks','Admin'));
    }

    public function editTask(Request $request, $id)
    {
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $english = [ 0 ,  1 ,  2 ,  3 ,  4 ,  5 ,  6 ,  7 ,  8 ,  9 ];

        $timechenger	= new CalendarUtils();

        $date1 = explode('/',str_replace($persian,$english ,$request->d1));
        $date3 = explode('/',str_replace($persian,$english ,$request->d3));




        $d1=$timechenger->toGregorian($date1[0],$date1[1],$date1[2]);
        $d3=$timechenger->toGregorian($date3[0],$date3[1],$date3[2]);


        $tasks = task::where('id', $id)->first();
        $tasks->status  = $request->status;
        $tasks->title   = $request->title  ;
        $tasks->task   = $request->task  ;
        $tasks->d1   = $d1[0].'-'.$d1[1].'-'.$d1[2]   ;
        $tasks->d3   = $d3[0].'-'.$d3[1].'-'.$d3[2]  ;
        $tasks->save();
        if ($Admin = Admin::where('name', $_COOKIE['admin'])->first()){
            if ($Admin->premises == 0){
                $tasks = task::all();
            }else{
                $tasks = task::where('admin_id', $Admin->id)->get();
            }
        }
        return view('content.tasks.index',compact('tasks','Admin'));
    }

    public function show($id)
    {
        $task = task::where('id', $id)->first();
        return view('adminpanel.task',compact('task'));
    }
    public function save(Request $request)
    {
        error_reporting(9);
        $timechenger	= new CalendarUtils();

        $date1 = explode('/',$request->d1);
        $date3 = explode('/',$request->d3);


        $d1=$timechenger->toGregorian($date1[0],$date1[1],$date1[2]);
        $d3=$timechenger->toGregorian($date3[0],$date3[1],$date3[2]);



        $tasks = new task();
        if ($request->project_id){
            $project = explode('|-|',$request->project_id);
            $tasks->project_id   = $project[0]  ;
            $tasks->project   = $project[1]  ;
        }
        if ($request->admin_id){
            $admin = explode('|-|',$request->admin_id);
            $tasks->admin_id   = $admin[0]  ;
            $tasks->admin   = $admin[1]  ;
        }
        $tasks->status  = $request->status ;
        $tasks->title   = $request->title  ;
        $tasks->task   = $request->task  ;
        $tasks->d1   = $d1[0].'-'.$d1[1].'-'.$d1[2]   ;
        $tasks->d3   = $d3[0].'-'.$d3[1].'-'.$d3[2]  ;
        $tasks->show_just_end   = $request->show_just_end  ;
        $tasks->maker   = $request->maker  ;
        $tasks->save();
        $tasks = task::all();
        if ($Admin = Admin::where('name', $_COOKIE['admin'])->first()){
            if ($Admin->remember_token == $_COOKIE['token']){
                return view('content.tasks.index',compact('tasks','Admin'));
            }
        }

    }
    public static function addtask()
    {
        //$Admins = DB::table('Admins')->where('deleted', 0)->get();
        if ($Admin = Admin::where('name', $_COOKIE['admin'])->first()){
            $Admins = Admin::where('deleted', 0)->/*where('premises', 2)->*/get();
            $Projects = project::all();
            return view('content.tasks.addTask',compact('Admins','Admin','Projects'));
        }

    }

    public function indexNote()
    {
        //نمایش تسک یا نوت بر اثاس مجوز و ادمین
        if ($Admin = Admin::where('name', $_COOKIE['admin'])->first()){
            $tasks = notes::where('admin_id', $Admin->id)->get();
        }
        return view('content.note.index',compact('tasks','Admin'));
    }

    public function saveNote(Request $request)
    {
        error_reporting(9);
        $timechenger	= new CalendarUtils();

        $date1 = explode('/',$request->d1);

        $d1=$timechenger->toGregorian($date1[0],$date1[1],$date1[2]);

        $tasks = new notes();
        $tasks->status  = $request->status ;
        $tasks->title   = $request->title  ;
        $tasks->task   = $request->task  ;
        $tasks->d1   = $d1[0].'-'.$d1[1].'-'.$d1[2]   ;
        $tasks->admin_id   = $request->admin_id  ;
        $tasks->save();
        if ($Admin = Admin::where('name', $_COOKIE['admin'])->first()){
            $tasks = notes::where('admin_id', $Admin->id)->get();
        }
        return view('content.note.index',compact('tasks','Admin'));

    }
    public function editNote(Request $request, $id)
    {
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $english = [ 0 ,  1 ,  2 ,  3 ,  4 ,  5 ,  6 ,  7 ,  8 ,  9 ];

        $timechenger	= new CalendarUtils();

        $date1 = explode('/',str_replace($persian,$english ,$request->d1));
        $d1=$timechenger->toGregorian($date1[0],$date1[1],$date1[2]);



        $tasks = notes::where('id', $id)->first();
        $tasks->status  = $request->status;
        $tasks->title   = $request->title  ;
        $tasks->task   = $request->task  ;
        $tasks->d1   = $d1[0].'-'.$d1[1].'-'.$d1[2]   ;

        $tasks->save();
        if ($Admin = Admin::where('name', $_COOKIE['admin'])->first()){
            $tasks = notes::where('admin_id', $Admin->id)->get();
        }
        return view('content.note.index',compact('tasks','Admin'));
    }

    public static function addNote()
    {
        //$Admins = DB::table('Admins')->where('deleted', 0)->get();
        if ($Admin = Admin::where('name', $_COOKIE['admin'])->first()){
            $Admins = Admin::where('deleted', 0)->/*where('premises', 2)->*/get();
            return view('content.note.addNote',compact('Admins','Admin'));
        }

    }
}
