<?php

use Illuminate\Support\Facades\Route;
use \App\Http\Controllers\usercontroller;
use \App\Http\Controllers\pagecontroller;
use \App\Http\Controllers\taskcontroller;
use \App\Http\Controllers\ticketController;
use \App\Http\Controllers\projectcontroller;
use \App\Http\Controllers\calendarController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('c', function () {
    
    Artisan::call('migrate');
});

Route::get('/', [usercontroller::class,'main_index']);

//demos
Route::get('test', [pagecontroller::class,'test']);
Route::get('tttest', [pagecontroller::class,'tttest']);
Route::get('hamed', function () {return view('test');});
Route::get('demo', function () {return view('test');});
Route::get('v', function () {return view('welcome');});

//tasks
Route::post('allTask', [taskcontroller::class,'index']);
Route::post('task', [taskcontroller::class,'index']);
Route::post('addTask', [taskcontroller::class,'addtask']);
Route::post('savenewtask', [taskcontroller::class,'save']);
Route::post('readtask/{id}', [taskcontroller::class,'show']);
Route::post('editTaskStatus/{id}', [taskcontroller::class,'editTaskStatus']);
Route::post('editTask/{id}', [taskcontroller::class,'editTask']);

//tiket
//Route::post('allTask', [tiketController::class,'index']);
Route::post('ticket', [ticketController::class,'index']);
Route::post('addTicket', [ticketController::class,'addTicket']);
Route::post('ticketCategory',  function () {return view('content.ticket.ticketCategory');});
Route::post('saveNewTicket', [ticketController::class,'saveNewTicket']);
Route::post('saveSubTicket', [ticketController::class,'saveSubTicket']);
Route::post('saveSubTicketFile', [ticketController::class,'saveSubTicketFile']);
Route::post('subTicket/{id}', [ticketController::class,'subTicket']);
//Route::post('editTaskStatus/{id}', [ticketController::class,'editTaskStatus']);
//Route::post('editTask/{id}', [ticketController::class,'editTask']);


//note
Route::post('allNote', [taskcontroller::class,'indexNote']);
Route::post('note', [taskcontroller::class,'indexNote']);
Route::post('addNote', [taskcontroller::class,'addNote']);
Route::post('editNote/{id}', [taskcontroller::class,'editNote']);
Route::post('saveNote', [taskcontroller::class,'saveNote']);
Route::post('readNote/{id}', [taskcontroller::class,'showNote']);

//project
Route::post('project', [projectcontroller::class,'project']);
Route::post('addProject', [projectcontroller::class,'addProject']);
Route::post('saveProject', [projectcontroller::class,'saveProject']);
Route::post('editProject/{project_id}', [projectcontroller::class,'editProject']);
Route::post('saveEditedProject/{project_id}', [projectcontroller::class,'saveEditedProject']);
//project_infos
Route::post('projectInfo', [projectcontroller::class,'projectInfo']);//نمایش همه
Route::post('editProjectInfos/{project_infos_id}', [projectcontroller::class,'editProjectInfos']);
Route::post('saveEditedInfoProject/{project_infos_id}', [projectcontroller::class,'saveEditedInfoProject']);
Route::post('project_infos/{project_id}', [projectcontroller::class,'projectInfoByProject']);//نمایش بر اثاث پروژه
Route::post('addproject_infos/{project_id}', [projectcontroller::class,'addproject_infos']);
Route::post('saveProject_infos/{project_id}', [projectcontroller::class,'saveProject_infos']);
//project_works
Route::post('project_works/{project_infos_id}', [projectcontroller::class,'project_worksByProjectInfo']);//نمایش بر اثاث پروژه
Route::post('project_works/{project_infos_id}/done/{workId}', [projectcontroller::class,'project_workActions']);
Route::post('project_works/{project_infos_id}/delete/{workId}', [projectcontroller::class,'project_workActions']);
Route::post('{project_id}/addproject_works', [projectcontroller::class,'addproject_works']);
Route::post('{project_id}/saveProject_works', [projectcontroller::class,'saveproject_works']);
Route::post('{project_id}/saveProject_works_excel', [projectcontroller::class,'saveProject_works_excel']);

// users
Route::get('user', [usercontroller::class,'user_login']);
Route::post('loginasuser', [usercontroller::class,'loginasuser']);
Route::post('adduser', [usercontroller::class,'register_user']);
Route::post('editUsers/{adminId}', [usercontroller::class,'editUsers']);
Route::post('savenewUser', [usercontroller::class,'saveNewUser']);
Route::post('users', [usercontroller::class,'users']);

Route::get('logOutMy', [usercontroller::class,'logOutMy']);
Route::post('saveprofilepic', [usercontroller::class,'saveprofilepic']);
//admins
Route::get('admin', [usercontroller::class,'admin_login']);
Route::post('loginasadmin', [usercontroller::class,'loginasadmin']);
Route::post('addadmins', [usercontroller::class,'register_admin']);
Route::post('savenewadmin', [usercontroller::class,'saveadmin']);
Route::post('editAdmins/{adminId}', [usercontroller::class,'editAdmins']);
Route::post('admins', [usercontroller::class,'admin']);

//calendar
Route::post('adminCalendarByMonth/{day}', [calendarController::class,'adminCalendar']);
Route::post('adminCalendarByWeek/{day}', [calendarController::class,'adminCalendar']);
Route::post('adminCalendarByDey/{day}', [calendarController::class,'adminCalendar']);



