
@extends('index')

@section('content')

    <div class="page-content">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-flex align-items-center justify-content-between">
                    <h4 class="page-title mb-0 font-size-18">عناصر فرم</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript:%20void(0);">فرم ها</a></li>
                            <li class="breadcrumb-item active">عناصر فرم</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">جدول&zwnj;های واکنشگرا</h4>
                        <p class="card-title-desc">
                            جدول های واکنش گرا را با قرار دادن هر <code>.table</code> داخل <code>.table-responsive</code> میتوانید ایجاد کنید تا در دستگاه های کوچک (زیر 768px) به صورت افقی اسکرول شوند.
                        </p>

                        <div class="table-responsive">
                            <form method="post" id="workActions">@csrf


                            <table class="table mb-0">
                                <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>title</th>
                                    <th>done</th>

                                    <th>del</th>

                                </tr>
                                </thead>
                                <tbody>
                                @foreach($projectInfo->projectWork as $projectWork)

                                    @if($projectWork->done == 0)@php($backgroundDoneClass = 'bg-gray')@php($btnDoneClass = 'btn-success')@php($btnDonetext = 'انجام دادم')@endif
                                    @if($projectWork->done == 1)@php($backgroundDoneClass = 'bg-light')@php($btnDoneClass = 'btn-danger')@php($btnDonetext = 'بازگردانی')@endif
                                    <tr class="{{$backgroundDoneClass}}">
                                        <th scope="row">{{$projectWork->id}}</th>


                                        <td>{!! $projectWork->title !!}</td>


                                        <td>
                                            <a onmousedown="document.getElementById('workActions').action = 'https://admin.borjeweb.com/project_works/{{$projectInfo->id}}/done/{{$projectWork->id}}'" onmouseup="document.getElementById('workActions').submit()" type="button" class="btn {{$btnDoneClass}} waves-effect waves-light text-light">
                                                  {{$btnDonetext}}
                                            </a>
                                        </td>

                                        @if($Admin->premises == 0)
                                            <td>
                                                <a onmousedown="document.getElementById('workActions').action = 'https://admin.borjeweb.com/project_works/{{$projectInfo->id}}/delete/{{$projectWork->id}}'" onmouseup="document.getElementById('workActions').submit()" type="button" class="btn btn-danger waves-effect waves-light text-light">
                                                      حذف
                                                </a>
                                            </td>
                                        @endif
                                    </tr>



                                @endforeach

                                </tbody>
                            </table>
                            </form>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection