<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_works', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->tinyInteger('done')->nullable()->default(0);
            $table->bigInteger('project_info_id')->unsigned()->nullable();
            $table->timestamps();
        });


//
//        Schema::table('tasks', function (Blueprint $table) {
//            $table->foreign('admin_id')->references('id')->on('admins');
//            $table->foreign('project_id')->references('id')->on('projects');
//
//        });
//        Schema::table('project_infos', function (Blueprint $table) {
//            $table->foreign('admin_id')->references('id')->on('admins');
//            $table->foreign('project_id')->references('id')->on('projects');
//
//        });
//
//        Schema::table('notes', function (Blueprint $table) {
//            $table->foreign('admin_id')->references('id')->on('admins');
//        });
//        Schema::table('project_works', function (Blueprint $table) {
//            $table->foreign('project_infos_id')->references('id')->on('project_infos');
//        });
//        Schema::table('users', function (Blueprint $table) {
//            $table->foreign('project_id')->references('id')->on('projects');
//        });
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('tasks');

        Schema::dropIfExists('project_works');
        Schema::dropIfExists('project_infos');
        Schema::dropIfExists('projects');

        Schema::dropIfExists('notes');
        Schema::dropIfExists('admins');

    }
};
