<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tikets', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger("status")->nullable();
            $table->text('title')->nullable();
            $table->longText('body')->nullable();
            $table->text('maker')->nullable();
            $table->text('file')->nullable();
            $table->text('admin')->nullable();
            $table->bigInteger('admin_id')->unsigned()->nullable();
            $table->text('user')->nullable();
            $table->bigInteger('user_id')->unsigned()->nullable();
            $table->text('project')->nullable();
            $table->bigInteger('project_id')->unsigned()->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tikets');
    }
};
